#include <stdlib.h>
#include "SDL/SDL.h"
#include "front_init.h"
#include "../common/structs.h"
#include "../common/debug.h"
#include <stdio.h>
#include "globals.h"
#include "console.h"

//extern scene_data* main_scene;
front_struct frontend_data;
front_struct* frontend = & frontend_data;

extern void (*print_function)(char*, va_list);
extern void (*print_frame_data)(char*, va_list);

void init_window(void)
{
	printd(DEBUG, "Initializing SDL window\n");
	frontend->screen = SDL_SetVideoMode(main_scene->width,
			main_scene->height,32, SDL_SWSURFACE);

	if(frontend->screen == NULL)
	{
		fprintf(stderr, "Error setting video mode\n");
		exit(1);
	}
}

void frontend_reinit(void)
{
//	free(frontend->screen);
	frontend->screen = NULL;
	init_window();
}

int frontend_init(void)
{
	printd(DEBUG, "Initializing SDL\n");
	if(SDL_Init(SDL_INIT_VIDEO) < 0)
	{
		fprintf(stderr, "Error initializing SDL\n");
		exit(1);
	}
	
	atexit(SDL_Quit);
	
	SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY , SDL_DEFAULT_REPEAT_INTERVAL);
	SDL_EnableUNICODE(1);
	
	printd(DEBUG, "Done with SDL Init\n");
	
	frontend_data.running = 1;
//	frontend_data.renderer = 0;
	frontend_data.look_on = 0;
	frontend_data.current_char = 0;
	frontend_data.console_on = 0;
//	frame_break_text = '\0';
	
	print_function = print_to_console;
	print_frame_data = save_for_frame_break;
	
	printd(NORMAL, "Welcome to slim!\nType '?' for help\nUse PgUp and PgDn to scroll the console\n");
	
	init_window();

	return 1;
}
